var button;
var doneCheckAuth = false;

function generateRandomKey() {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}

function getAppId() {
    var href = $('a[data-testid="get-app-btn"]').attr('href');

    if (!href) {
        return false;
    }

    var exploded = href.split('/');
    var appId = exploded[6];

    return appId;
}

function getAppName() {
    var appName = $('section[data-testid="app-card"] h1').text();

    return appName;
}

function getAppInfo(appId) {
    var appName = getAppName();

    $.ajax({
        url: 'https://bigowl.bcutils.com/api/info?app_id=' + appId + '&app_name='+ appName +'&app_url='+ window.location.href +'&token=' + localStorage.getItem('token'),
        method: 'GET',
        success: function(data) {
            if (data.success) {
                var competitors = '';
                var clientSites = '';
                var tags = '';
                var info = data.data;
                var tagOptions = '';

                if (info.competitors) {
                    for (var i = 0; i < info.competitors.length; i++) {
                        competitors += `<div style="display: flex; align-items: center;">
                            <div style="padding: 2px; text-align: right; width: 100%; margin-right: 5px;">
                                ${info.competitors[i]}
                                <input type="hidden" name="competitors[]" value="${info.competitors[i]}">
                            </div>
                            <svg class="remove-list" style="width: 15px; height: 15px; cursor: pointer; fill: #e74c3c;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                        </div>`;
                    }
                }

                if (info.client_sites) {
                    for (var i = 0; i < info.client_sites.length; i++) {
                        clientSites += `<div style="display: flex; align-items: center;">
                            <div style="padding: 2px; text-align: right; width: 100%; margin-right: 5px;">
                                ${info.client_sites[i]}
                                <input type="hidden" name="client_sites[]" value="${info.client_sites[i]}">
                            </div>
                            <svg class="remove-list" style="width: 15px; height: 15px; cursor: pointer; fill: #e74c3c;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                        </div>`;
                    }
                }

                if (info.tags) {
                    for (var i = 0; i < info.tags.length; i++) {
                        tags += `<div style="display: flex; align-items: center;">
                            <div style="padding: 2px; text-align: right; width: 100%; margin-right: 5px;">
                                <div class="tag-item" style="color: #0d52ff; text-decoration: underline; cursor: pointer;">${info.tags[i]}</div>
                                <input type="hidden" name="tags[]" value="${info.tags[i]}">
                            </div>
                            <svg class="remove-list" style="width: 15px; height: 15px; cursor: pointer; fill: #e74c3c;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                        </div>`;
                    }
                }

                var html = `
                    <ul>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Name:</div>
                                <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; display: none;">close</div>
                            </div>
                            <div style="text-align: right;">
                                <input type="text" class="focusout" value="${info.app_name ? info.app_name : appName}" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;" name="app-name">
                                <div class="info-text" style="margin-right: 10px; width: 100%; text-align: right;">${info.app_name ? info.app_name : appName}</div>
                            </div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Partner:</div>
                                <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; display: none;">close</div>
                            </div>
                            <div style="text-align: right;">
                                <input type="text" class="focusout" value="${info.partner ? info.partner : ''}" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;" name="partner">
                                <div class="info-text" style="margin-right: 10px; width: 100%; text-align: right;">${info.partner ? info.partner : ''}</div>
                            </div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Slack:</div>
                                <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; display: none;">close</div>
                            </div>
                            <div style="text-align: right;">
                                <input type="text" class="focusout" value="${info.slack ? info.slack : ''}" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;" name="slack">
                                <div class="info-text" style="margin-right: 10px; width: 100%; text-align: right;">${info.slack ? info.slack : ''}</div>
                            </div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Relationship Manager:</div>
                                <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; display: none;">close</div>
                            </div>
                            <div style="text-align: right;">
                                <input type="text" class="focusout" value="${info.rmgr ? info.rmgr : ''}" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;" name="rmgr">
                                <div class="info-text" style="margin-right: 10px; width: 100%; text-align: right;">${info.rmgr ? info.rmgr : ''}</div>
                            </div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Tags:</div>
                                <div style="display: flex; align-items: center;">
                                    <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                    <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; text-align: right; display: none;">close</div>
                                </div>
                            </div>
                            <div style="display: flex; align-items: center; justify-content: space-between;">
                                <select class="select2" name="tags" style="width: 100%; border-radius: 0; text-align: right; display: none;"></select>

                                <div class="add" style="margin-left: 5px; cursor: pointer; color: #0D52FF; display: none;" data-name="tags">Add</div>
                            </div>
                            <div class="info-list">${tags}</div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Competitors:</div>
                                <div style="display: flex; align-items: center;">
                                    <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                    <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; text-align: right; display: none;">close</div>
                                </div>
                            </div>
                            <div style="display: flex; align-items: center; justify-content: space-between;">
                                <input type="text" value="" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;">
                                <div class="add" style="margin-left: 5px; cursor: pointer; color: #0D52FF; display: none;" data-name="competitors">Add</div>
                            </div>
                            <div class="info-list">${competitors}</div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">Client Sites:</div>
                                <div style="display: flex; align-items: center;">
                                    <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                    <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; text-align: right; display: none;">close</div>
                                </div>
                            </div>
                            <div style="display: flex; align-items: center; justify-content: space-between;">
                                <input type="text" value="" style="padding: 2px; border: 1px solid #000; background-color: transparent; text-align: right; width: 100%; display: none;">
                                <div class="add" style="margin-left: 5px; cursor: pointer; color: #0D52FF; display: none;" data-name="client_sites">Add</div>
                            </div>
                            <div class="info-list">${clientSites}</div>
                        </li>
                        <li style="margin: 5px 0; border-bottom: 1px solid #ccc; padding: 10px 0;">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div style="margin-right: 5px;">PSR?:</div>
                                <svg class="info-edit" style="min-width: 15px; min-height: 15px; width: 15px; height: 15px; cursor: pointer; display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"/></svg>
                                <div class="close" style="text-decoration: underline; color: #0d52ff; cursor: pointer; font-size: 12px; display: none;">close</div>
                            </div>
                            <div style="text-align: right;">
                                <input type="checkbox" class="focusout" value="yes" ${info.psr && info.psr == 'yes' ? 'checked' : ''} style="display: none;" name="psr">
                                <div class="info-text" style="margin-right: 10px; width: 100%; text-align: right;">${info.psr ? info.psr : ''}</div>
                            </div>
                        </li>
                    </ul>

                    <div style="text-align: center; margin-top: 20px;">
                        <button id="save-info" style="padding: 10px 20px; background-color: #0D52FF; color: white; border: none; cursor: pointer;">Save</button>
                    </div>
                `;

                $('#bigowl-panel .body #info div').html(html);

                // Initialize select2
                $.getJSON( "https://bigowl.bcutils.com/tags", function(response) {
                    $('#bigowl-panel .select2').select2({
                        data: response
                    });

                    $('#bigowl-panel .select2').css('display', 'none');
                 });
            } else {

            }
        },
        error: function(response) {

        }
    });
}

function getComments(appId) {
    $.ajax({
        url: 'https://bigowl.bcutils.com/api/comments?app_id=' + appId + '&token=' + localStorage.getItem('token'),
        method: 'GET',
        success: function(data) {
            if (data.success) {
                var commentLists = '';
                var comments = data.data;

                if (comments) {
                    for (var i = 0; i < comments.length; i++) {
                        commentLists += `<li style="margin-bottom: 10px;">
                            <div>
                                <div style="font-weight: bold;">${comments[i].title}</div>
                                <div>${comments[i].comment}</div>
                            </div>
                            <div style="border-bottom: 1px solid #ccc; text-align: right; font-size: 12px;">
                                <div>${comments[i].user.name}</div>
                                <div>${comments[i].created_at}</div>
                            </div>
                        </li>`;
                    }

                    $('#bigowl-panel .body #comment-list').html('<ul>' + commentLists + '</ul>');
                } else {
                    $('#bigowl-panel .body #comment-list').html('<div style="text-align: center;">No comments found.</div>');
                }
            }
        },
        error: function(response) {

        }
    });
}

async function checkAuth() {
    var appId = getAppId();
    var token = localStorage.getItem('token');
    var info = {};

    // Add a floating button to the page
    if (!$('#bigowl-button').length && appId) {
        button = $('<button id="bigowl-button"><img src="'+ chrome.runtime.getURL("images/owl.svg") +'" style="width: 30px; height: auto; padding-top: 10px;"></button>');
        button.css({
            'position': 'fixed',
            'bottom': '75%',
            'margin-bottom': '-20px',
            'right': '0',
            'z-index': '1000',
            'background-color': '#000',
            'color': 'white',
            'padding': '0 20px'
        });
        button.appendTo('body');
    }

    if (!token) {
        token = generateRandomKey();

        localStorage.setItem('token', token);
    }

    $.ajax({
        url: 'https://bigowl.bcutils.com/check',
        method: 'POST',
        data: {
            token: localStorage.getItem('token')
        }
    }).done(function(response) {
        if (response.success) {
            if (appId) {
                $('#bigowl-panel #feedback-form [name="$name"]').val(response.user.name);
                $('#bigowl-panel #feedback-form [name="$email"]').val(response.user.email);

                button.css('background-color', '#0D52FF');

                getAppInfo(appId);
                getComments(appId);

                $('#bigowl-panel .body').html(`
                    <div id="info">
                        <input type="hidden" name="app_id" value="${appId}">
                        <input type="hidden" name="app_url" value="${window.location.href}">
                        <div style="text-align: center;">
                            <span class="bigowl-loader" style="margin-top: 30px;"></span>
                        </div>
                    </div>
                    <div id="comments">
                        <div style="padding: 5px 0;">
                            <input type="hidden" name="app_id" value="${appId}">
                            <input type="text" id="title" name="title" style="padding: 2px; border: 1px solid #000; background-color: transparent; width: 100%;" placeholder="Title">
                        </div>
                        <div style="padding: 5px 0;">
                            <textarea id="comment" name="comment" style="width: 100%; height: 100px; padding: 2px; border: 1px solid #000; margin-bottom: 10px;" placeholder="Your comment here..."></textarea>
                        </div>

                        <div style="text-align: center;">
                            <button id="save-comment" style="padding: 10px 20px; background-color: #0D52FF; color: white; border: none; cursor: pointer;">Save</button>
                        </div>

                        <div id="comment-list" style="margin-top: 20px; height: 600px; overflow-y: scroll;">
                            <div style="text-align: center;">
                                <span class="bigowl-loader"></span>
                            </div>
                        </div>
                    </div>
                `);

                $('#bigowl-button').css('background-color', '#0D52FF');
                $('#bigowl-button').addClass('auth');

                // Show the first tab by default
                $('#bigowl-panel .body #comments').hide();
                $('#bigowl-panel .body #info').show();
                $('#bigowl-panel .tabs-nav li:first').addClass('tab-active');
            } else {
                $('#bigowl-button').remove();
            }
        } else {
            if (!appId) {
                $('#bigowl-button').remove();
            }
        }

        doneCheckAuth = true;
    });

    // Check if localstorage token exists
    if (!localStorage.getItem('token')) {
        $('#bigowl-button').css('background-color', '#000');
    }
}

$(document).ready(function() {
    setTimeout(checkAuth, 2000);

    (async () => {
        // Add a slideout panel
        var html = `<div id="bigowl-panel" style="position: fixed; bottom: 50%; right: -300px; top: 0; width: 300px; height: 100%; background-color: white; border-left: 3px solid #0D52FF; z-index: 1000; margin-bottom: -100px; overflow-y: auto;">
            <div style="border-left: 1px solid #000; padding: 10px; height: 100%;">
                <div style="display: flex; align-items: center; justify-content: space-between;">
                    <div style="display: flex; align-items: center; justify-content: center;">
                        <img src="${chrome.runtime.getURL("images/owl-black.svg")}" style="width: 50px; height: 50px;">
                        <h1 style="text-align: center; margin-top: 8px;">BigOwl</h1>
                    </div>

                    <div style="cursor: pointer;">
                        <svg style="width: 15px;" id="menu-dropdown" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z"/></svg>

                        <div id="menu-dropdown-content" style="display: none; position: absolute; top: 57px; right: 0; background-color: #fff; border: 1px solid #000; padding: 10px; z-index: 1000;">
                            <div style="cursor: pointer;" id="feedback">Feedback</div>
                            <div style="cursor: pointer;" id="logout">Logout</div>
                        </div>
                    </div>
                </div>

                <div id="tabs">
                    <ul class="tabs-nav">
                        <li class="tab-active"><a href="#info">Info</a></li>
                        <li><a href="#comments">Comments</a></li>
                    </ul>
                    <div class="body">

                    </div>
                </div>
                <div id="tags" style="display: none;">

                </div>
                <div id="feedback-form" style="display: none;">
                    <h2 style="margin-bottom: 12px; font-size: 20px; font-weight: bold;">Feedback</h2>

                    <form action="https://api.staticforms.xyz/submit" method="post" id="feedback-form-form">
                        <input type="hidden" name="accessKey" value="496442be-f3be-4de4-b31a-545ebbfd6ee2">
                        <input type="hidden" name="$url" value="${window.location.href}">
                        <input type="text" name="subject" placeholder="Subject" style="padding: 2px; border: 1px solid rgb(0, 0, 0); background-color: transparent; width: 100%; margin-bottom: 5px;">
                        <textarea rows="8" name="message" placeholder="Message..." required style="padding: 2px; border: 1px solid rgb(0, 0, 0); background-color: transparent; width: 100%; margin-bottom: 1px;"></textarea>
                        <input type="hidden" name="$name" value="">
                        <input type="hidden" name="$email" value="">
                        <input type="hidden" name="$browser" value="${platform.name}">
                        <input type="hidden" name="$os" value="${platform.os}">
                        <input type="text" name="honeypot" style="display:none">

                        <div style="text-align: right;">
                            <input type="button" value="Cancel" style="padding: 10px 20px; background-color: #fff; border: 1px solid #ccc; color: #000; cursor: pointer;" id="feedback-cancel" />
                            <input type="submit" value="Submit" style="padding: 10px 20px; background-color: #0D52FF; color: white; border: 1px solid #0D52FF; cursor: pointer;" />
                        </div>
                    </form>
                </div>
            </div>
        </div>`;
        $('body').append(html);

        // Add a click event to the button
        $('body').on('click', '#bigowl-button',function() {
            if (!doneCheckAuth) {
                return;
            }

            if (!$('#bigowl-button').hasClass('auth')) {
                window.location.href = 'https://bigowl.bcutils.com/login?key=' + localStorage.getItem('token') + '&redirect_url=' + window.location.href;

                return;
            }

            if ($('#bigowl-button').hasClass('active')) {
                $('#bigowl-panel').animate({
                    right: '-300px'
                }, 500);

                $('#bigowl-button').animate({
                    right: '0'
                }, 500);

                $('#bigowl-button').removeClass('active');

                $('#bigowl-button').find('img').attr('src', chrome.runtime.getURL("images/owl.svg"));
            } else {
                $('#bigowl-panel').animate({
                    right: '0'
                }, 500);

                $('#bigowl-button').animate({
                    right: '300px'
                }, 500);

                $('#bigowl-button').addClass('active');
            }
        });

        // Change tab class and display content
        $('body').on('click', '#bigowl-panel .tabs-nav a', function(event){
            event.preventDefault();

            $('#bigowl-panel .tabs-nav li').removeClass('tab-active');
            $(this).parent().addClass('tab-active');
            $('#bigowl-panel .body > div').hide();
            $($(this).attr('href')).show();
        });

        $('body').on('click', '#bigowl-panel .info-edit', function(event){
            event.preventDefault();

            var input = $(this).closest('li').find('input');
            var select2 = $(this).closest('li').find('.select2');

            select2.show();
            select2.focus();
            $(this).closest('li').find('.add').show();

            input.show();
            input.focus();
            $(this).closest('li').find('.add').show();

            $(this).closest('li').find('.info-text').hide();
            $(this).closest('li').find('.close').show();

            $(this).addClass('hide');
            $(this).hide();
        });

        $(document).on('keydown', '#bigowl-panel .body .select2', function(event) {
            if (event.key == 'Escape') {
                var input = $(this);
                var value = input.val();

                input.closest('li').find('.info-text').text(value);

                input.hide();
                input.closest('li').find('.add').hide();

                input.closest('li').find('.info-edit').removeClass('hide');
                input.closest('li').find('.info-text').show();

                input.closest('li').find('.close').hide();
            }
        });

        $(document).on('keydown', '#bigowl-panel .body input', function(event) {
            if (event.key == 'Escape') {
                var input = $(this);
                var value = input.val();

                input.closest('li').find('.info-text').text(value);

                input.hide();
                input.closest('li').find('.add').hide();

                input.closest('li').find('.info-edit').removeClass('hide');
                input.closest('li').find('.info-text').show();

                input.closest('li').find('.close').hide();
            }
        });

        $('body').on('click', '#bigowl-panel .add', function(event){
            event.preventDefault();

            var input = $(this).prev('input');
            var select2 = $(this).prev('.select2');
            var value = '';
            var name = '';

            if (input.length) {
                var value = input.val();
                var name = $(this).data('name');
            } else if (select2.length) {
                var data = $(this).closest('li').find('select.select2').select2('data');
                var value = data[0].text;
                var name = $(this).data('name');
            }

            if (value) {
                var label = value.trim();

                if (name == 'tags') {
                    label = '<div class="tag-item" style="color: #0d52ff; text-decoration: underline; cursor: pointer;">' + label + '</div>';
                }

                var text = `<div style="display: flex; align-items: center;">
                    <div style="padding: 2px; text-align: right; width: 100%; margin-right: 5px;">
                        ${label}
                        <input type="hidden" name="${name}[]" value="${value}">
                    </div>
                    <svg class="remove-list" style="width: 15px; height: 15px; cursor: pointer; fill: #e74c3c;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg></div>`;
                $(this).closest('li').find('.info-list').append(text);
                input.val('');
            }

            input.focus();
        });

        $('body').on('click', '#bigowl-panel .remove-list', function(event){
            event.preventDefault();

            $(this).parent().remove();
        });

        $('body').on('click', '#save-info', function(event){
            event.preventDefault();

            var self = this;
            var data = {
                token: localStorage.getItem('token'),
                app_id: $('input[name="app_id"]').val(),
                app_name: $('input[name="app-name"]').val(),
                app_url: $('input[name="app_url"]').val(),
                partner: $('input[name="partner"]').val(),
                slack: $('input[name="slack"]').val(),
                rmgr: $('input[name="rmgr"]').val(),
                competitors: [],
                client_sites: [],
                psr: $('input[name="psr"]').is(':checked') ? 'yes' : 'no',
                tags: []
            };

            // spinner icon
            $(self).text('Saving...');
            $(self).css('background-color', '#FFA500');

            $('#bigowl-panel .body input[name="competitors[]"]').each(function(index, input){
                data.competitors.push($(input).val());
            });

            $('#bigowl-panel .body input[name="client_sites[]"]').each(function(index, input){
                data.client_sites.push($(input).val());
            });

            $('#bigowl-panel .body input[name="tags[]"]').each(function(index, input){
                data.tags.push($(input).val());
            });

            $.ajax({
                url: 'https://bigowl.bcutils.com/api/info',
                method: 'POST',
                data: data
            }).done(function(response) {
                if (response.success) {
                    $(self).text('Saved');
                    $(self).css('background-color', '#2ecc71');

                    $('#bigowl-panel .body #info input').hide();
                    $('#bigowl-panel .body #info .select2').hide();
                    $('#bigowl-panel .body .add').hide();
                    $('#bigowl-panel .body .info-edit').hide();
                    $('#bigowl-panel .body .close').hide();
                    $('#bigowl-panel .body .info-edit').removeClass('hide');
                    $('#bigowl-panel .body .info-text').show();

                    setTimeout(function(){
                        $(self).text('Save');
                        $(self).css('background-color', '#0D52FF');
                    }, 2000);
                }
            });
        });

        $('body').on('click', '#save-comment', function(event){
            event.preventDefault();

            var self = this;
            var data = {
                token: localStorage.getItem('token'),
                app_id: $('input[name="app_id"]').val(),
                title: $('#title').val(),
                comment: $('#comment').val()
            };

            // spinner icon
            $(self).text('Saving...');
            $(self).css('background-color', '#FFA500');

            $.ajax({
                url: 'https://bigowl.bcutils.com/api/comments',
                method: 'POST',
                data: data
            }).done(function(response) {
                if (response.success) {
                    // clear out input fields
                    $('#title').val('');
                    $('#comment').val('');

                    $(self).text('Saved');
                    $(self).css('background-color', '#2ecc71');
                    var data = response.data;

                    var comment = `
                        <li style="margin-bottom: 10px;">
                            <div>
                                <div style="font-weight: bold;">${data.title}</div>
                                <div>${data.comment}</div>
                            </div>
                            <div style="border-bottom: 1px solid #ccc; text-align: right; font-size: 12px;">
                                <div>${data.user.name}</div>
                                <div>${data.created_at}</div>
                            </div>
                        </li>
                    `;

                    $('#bigowl-panel #comment-list ul').prepend(comment);

                    setTimeout(function(){
                        $(self).text('Save');
                        $(self).css('background-color', '#0D52FF');
                    }, 2000);
                }
            });
        });

        $('body').on('mouseover', '#bigowl-panel #info ul li', function(e) {
            e.preventDefault();

            var edit = $(this).find('.info-edit');

            if (!edit.hasClass('hide')) {
                edit.show();
            }
        });

        $('body').on('mouseout', '#bigowl-panel #info ul li', function(e) {
            e.preventDefault();

            var edit = $(this).find('.info-edit');

            if (!edit.hasClass('hide')) {
                edit.hide();
            }
        });

        $('body').on('click', '.tag-item', function(e) {
            e.preventDefault();

            var tag = $(this).text();

            $('#bigowl-panel #tags').html(`
                <div style="display: flex; align-items: center; padding: 10px 0;">
                    <svg class="back-tag" style="width: 15px; height: 15px; cursor: pointer; fill: #e74c3c; margin-right: 10px;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M41.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 256 246.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160zm352-160l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L301.3 256 438.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0z"/></svg>

                    <div>Tag: <span style="font-weight: bold;">${tag}</span></div>
                </div>
                <div id="list">
                    <div style="text-align: center;">
                        <span class="bigowl-loader"></span>
                    </div>
                    <ul>

                    </ul>
                </div>
            `);

            $('#bigowl-panel #tabs').hide();
            $('#bigowl-panel #tags').show();

            $.ajax({
                url: 'https://bigowl.bcutils.com/api/apps?tag=' + tag + '&token=' + localStorage.getItem('token'),
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        var html = '';
                        var data = response.data;

                        if (data) {
                            for (var i = 0; i < data.length; i++) {
                                html += `<li style="margin-bottom: 5px;">
                                    <div style="color: #0d52ff; text-decoration: underline; cursor: pointer;" data-href="${data[i].app_url}">${data[i].app_name}</div>
                                </li>`;
                            }

                            $('#bigowl-panel #tags #list').html('<ul>' + html + '</ul>');
                        }
                    } else {
                        $('#bigowl-panel #tags #list').html('<div style="text-align: center;">No data found.</div>');
                    }
                }
            });
        });

        $('body').on('click', '.back-tag', function(e) {
            e.preventDefault();

            $('#bigowl-panel #tags').hide();
            $('#bigowl-panel #tabs').show();
        });

        $('body').on('click', '#bigowl-panel #tags #list ul li div', function(e) {
            e.preventDefault();

            var url = $(this).data('href');

            if (url) {
                window.location.href = url;
            }
        });

        $('body').on('click', '#menu-dropdown', function(e) {
            e.preventDefault();

            var content = $('#menu-dropdown-content');

            if (content.is(':visible')) {
                content.hide();
            } else {
                content.show();
            }
        });

        $('body').on('click', '#logout', function(e) {
            e.preventDefault();

            // Show spinner
            $(this).html('<div style="text-align: center;">Logout <span class="bigowl-loader" style="width: 12px; height: 12px; border-width: 1px;"></span></div>');

            $.ajax({
                url: 'https://bigowl.bcutils.com/logout',
                method: 'GET',
                data: {
                    token: localStorage.getItem('token')
                }
            }).done(function(response) {
                if (response.success) {
                    // Close panel
                    $('#bigowl-panel').animate({
                        right: '-300px'
                    }, 500);

                    $('#bigowl-button').animate({
                        right: '0'
                    }, 500);

                    $('#bigowl-button').removeClass('active');
                    $('#bigowl-button').removeClass('auth');
                    $('#bigowl-button').css('background-color', '#000');
                }
            });
        });

        $('body').on('click', '#feedback', function(e) {
            e.preventDefault();

            $('#bigowl-panel #feedback-form').show();

            $('#bigowl-panel #tabs').hide();
            $('#bigowl-panel #tags').hide();

            $('#menu-dropdown-content').hide();
        });

        $('body').on('submit', '#feedback-form-form', function(e) {
            e.preventDefault();

            var form = $(this);
            var data = {};
            form.serializeArray().forEach(function(item) {
                if (item.name == 'subject') {
                    if (item.value) {
                        data[item.name] = 'BigOwl Feedback: ' + item.value;
                    } else {
                        data[item.name] = 'BigOwl Feedback';
                    }
                } else {
                    data[item.name] = item.value;
                }
            });

            // Show spinner
            form.find('input[type="submit"]').val('Sending...');
            form.find('input[type="submit"]').css('background-color', '#FFA500');

            $.ajax({
                url: 'https://api.staticforms.xyz/submit',
                method: 'POST',
                data: new URLSearchParams(data).toString()
            }).done(function(response) {
                if (response.success) {
                    form.find('input[type="submit"]').val('Sent');
                    form.find('input[type="submit"]').css('background-color', '#2ecc71');

                    // Clear out input fields
                    form.find('input[name="subject"]').val('');
                    form.find('textarea[name="message"]').val('');

                    setTimeout(function(){
                        form.find('input[type="submit"]').val('Submit');
                        form.find('input[type="submit"]').css('background-color', '#0D52FF');
                    }, 2000);
                }
            });
        });

        $('body').on('click', '#feedback-cancel', function(e) {
            e.preventDefault();

            $('#bigowl-panel #feedback-form').hide();
            $('#bigowl-panel #tags').hide();

            $('#bigowl-panel #tabs').show();
        });

        $('body').on('click', '#bigowl-panel .body .close', function(e) {
            e.preventDefault();

            var input = $(this).closest('li').find('input');
            var select2 = $(this).closest('li').find('.select2');
            var value = input.val();

            if (input.attr('type') == 'checkbox') {
                value = input.is(':checked') ? 'yes' : 'no';
            }

            $(this).closest('li').find('.info-text').text(value);

            input.hide();
            input.next('.add').hide();

            select2.hide();
            select2.next('.add').hide();

            $(this).closest('li').find('.info-edit').removeClass('hide');
            $(this).closest('li').find('.info-text').show();

            $(this).hide();
        });
    })();
});

